------------------------------------------------------------
-- Attach Multiple Masks to path, keep position.dfscript
--
-- Revision: 2.0
--
-- USE: Run the script from the composition, select the masks you want to affect,
-- select the path, and click okay.  The script will create an offset position 
-- that will keep the tool locked in its current position, instead of having it
-- thrown to wherever the path's center is.
-- The masks will then animate along the path's center.
--
-- Used with permission by Frantic Films (http://www.franticfilms.com)
-- written by Sean Konrad (sean@eyeonline.com)
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------


print("\n\n----------------------------------------------\nATTACH MASK KEEP POSITION:\n----------------------------------------------\n")

-- Define what the RegIDs for every mask are.
mask_ids = {}
table.insert(mask_ids, "PolylineMask") -- polygon
table.insert(mask_ids, "BSplineMask") -- polygon
table.insert(mask_ids, "RectangleMask") -- rectangle
table.insert(mask_ids, "EllipseMask") -- ellipse
--tinsert(mask_ids, 1934455380) -- triangle  
-- Triangles were eliminated as they have no "center" points.
-- Same with wands.
table.insert(mask_ids, "BitmapMask") -- bitmap

-- Define the Path ID
pathid = "PolyPath"

-- Some variable declarations for later.
toollist = composition:GetToolList(true)
masklist = {}
pathlist = {}
pathcount=0
nomasks = true
nopaths=true
maskcount=0
maskdump={}
pathdump={}
trackercount=0
trackerlist={}
trackerdump={}

-- Determine what tools are Masks and what tools are paths
for i = 1, table.getn(toollist) do
	local var1 = toollist[i]:GetAttrs()
	
	-- Check to see if the current tool is a mask.
	if bmd.isin(mask_ids, var1.TOOLS_RegID) then
		-- You need storage for the mask's name and the mask's
		-- tool name.  One will be used internally by the script,
		-- the other will be displayed to the user.
		maskcount = maskcount +1
		masklist[maskcount]=var1.TOOLS_Name
		maskdump[maskcount] = toollist[i]
		-- It's found a mask, so the nomask check can now be false.
		nomasks=false
	end 
	
	-- If it's not a mask, is it a path?
	if var1.TOOLS_RegID == pathid then
		-- Similar reasoning to above.
		pathcount=pathcount+1
		pathlist[pathcount]=var1.TOOLS_Name
		pathdump[pathcount]=toollist[i]
		
		-- It's found a path, so the nopaths check can be false.
		nopaths=false
	end
end
-- Sanity checks.

-- Check to see if the tool has masks at all..
if nopaths then
		d = {}
		d = {"Msg", Name = "Warning", "Text", ReadOnly = true, Lines = 5, Default = errormsg }
		composition:AskUser("You've got no Paths", d)
		return
else
-- Check to see if the composition has Masks at all..
	if nomasks then
		d = {}
		d = {"Msg", Name = "Warning", "Text", ReadOnly = true, Lines = 5, Default = errormsg }
		composition:AskUser("You've got no masks", d)
		return
	else
		--Ask the user what masks they want to attach to a path
		--which the user will specify.
		--Also ask what path values they want to attach it to.
		d = {}
		-- Display a list of all masks in the composition so that they can attach the path to the selected mask.
		-- Of course this has the distinct possibility of displaying too many masks for the user's display.
		-- That would be bad.  If there are a number of masks in the composition, warn the user.
		ret= nil
		if maskcount > 90 then
			ret={}
			ret = AskUser("Too many masks...", 
			{
			{"Msg", Name = "", "Text", Readonly = true, Lines = 9, Default = "You have a lot of masks in your composition. \nIf the number of masks exceeds the height of your monitor, you may not be able to cancel.  \nTo solve this, try copying the needed masks and paths to a new composition, and then running the script. ", Wrap=true},
			{"Continue?", "Checkbox", Default = 0}
			})
			
			
			if ret then
				if ret["Continue?"] == 0 then
					print("Cancelled!") 
					return
				end
			else
				print("Cancelled!")
				return
			end
		end
		
		-- Reset ret.
		ret = nil
		for i = 1, maskcount do
			d[i] = {masklist[i], Name = masklist[i], "Checkbox", Default = 0, NumAcross = 3 }
		end
		d[maskcount+1] = {"Msg", Name = "", "Text", ReadOnly = true, Lines = 1, Default = "Connect Above Mask(s) to:"}
		counter = 0
		stringset={}
		for i = 1, pathcount do
			table.insert(stringset, pathlist[i])
		end
		d[maskcount+2] = {"Dropdown", Name = "Path", "Dropdown", Options=stringset, Default = 0}
		ret = {}
		ret= composition:AskUser("Select Your Masks", d)
		
		if ret == nil then
			print("Cancelled!")
			return
		end
		
		-- Flag the path for easy reference.
		thisisthepath=pathdump[ret.Dropdown+1]
		
		-- Start the undo action...
		composition:StartUndo("Attach Masks to Tracker")
		
		--Disconnect old modifiers just in case someone's kept them there.
		for i=1, maskcount do
			if ret[masklist[i]] == 1 then
				maskdump[i].Center=nil
			end
		end
		-- Determine what tools are offsets so that later on when we add new ones
		-- we can compare them to this list.  Make a new toollist for good masure.
		offsetcount=0
		offsetdump={}
		offsetlist={}
		toollist3={}
		toollist3=composition:GetToolList()
		for i = 1, table.getn(toollist3) do
			k = toollist3[i]:GetAttrs()
			if k.TOOLS_RegID == "Offset" then
				offsetcount=offsetcount+1
				offsetdump[offsetcount]=toollist3[i]
				offsetlist[offsetcount]=k.TOOLS_Name
			end
		end	
		-- Cycle through the lists of masks to see which ones were chosen,
		-- grab their current x,y positions so they won't move
		for i = 1, maskcount do
			if ret[masklist[i]] == 1 then
				oldcenter={}
				oldcenter[1] = maskdump[i].Center[CurrentTime][1]
				oldcenter[2] = maskdump[i].Center[CurrentTime][2]
				var10=composition:GetAttrs()
				-- Make an offset position on the tool's center.
				maskdump[i].Center = Offset({Offset = {0,0}})
				-- You've added tools, so a new toollist might be in order.
				toollist2 = composition:GetToolList()
				for m = 1, table.getn(toollist2) do
					k = toollist2[m]:GetAttrs()
					if k.TOOLS_RegID == "Offset" then  --RegID for offsets -- cycle through and see what tools are new
						inarray=false
						for l = 1, offsetcount do
							-- Check to see if the offset is in the list so we don't affect an old one
							if k.TOOLS_Name == offsetlist[l] then
								inarray=true
							end
						end
						if inarray == true then
						else
							-- Position the offset based on the old center's difference from the new center.
							print("   Connecting "..masklist[i].." to "..thisisthepath:GetAttrs().TOOLS_Name..".")
							offsetcount=offsetcount+1
							
							-- Connect the Position of the Offset to the Position of the path.
							toollist2[m].Position=thisisthepath.Position
							newcenter={}
							newcenter[1]=maskdump[i].Center[CurrentTime][1]
							newcenter[2]=maskdump[i].Center[CurrentTime][2]
							
							offsetx = (oldcenter[1]-newcenter[1])
							offsety = (oldcenter[2]-newcenter[2])
							toollist2[m].Offset = {offsetx, offsety}
							offsetdump[offsetcount]=toollist2[m]
							offsetlist[offsetcount]=k.TOOLS_Name
						end
					end
				end
			end	
		end
	end
end

-- End the Undo action.
composition:EndUndo(true)

